/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.io;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.graphics.Bitmap;
import android.os.SystemClock;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.gprinter.bean.PrinterDevices;
import com.gprinter.io.PortManager;
import com.gprinter.utils.CallbackListener;
import com.gprinter.utils.Command;
import com.gprinter.utils.GpUtils;
import com.gprinter.utils.LogUtils;
import com.gprinter.utils.PDFUtils;
import com.gprinter.utils.SDKUtils;
import com.gprinter.utils.UIThreadManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;

public class BluetoothPort
extends PortManager {
    private static final String TAG = BluetoothPort.class.getSimpleName();
    private static final UUID SERIAL_PORT_SERVICE_CLASS_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private BluetoothAdapter mAdapter = null;
    private BluetoothDevice device;
    private BluetoothSocket mSocket;
    private int len = -1;
    private String macAddress;
    private CallbackListener callbackListener;
    private List<CallbackListener> callbackListenerList = new ArrayList<CallbackListener>();
    private Command command = null;
    private byte[] buffer = new byte[128];
    private boolean isConn = false;
    private boolean isSafety = false;
    private IoReader reader = null;
    private final Object lock = new Object();
    private PrinterDevices mPrinterDevices = null;
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();

    @Override
    public boolean getConnectStatus() {
        return this.isConn;
    }

    public BluetoothPort(PrinterDevices printerDevices) {
        if (printerDevices != null) {
            this.mPrinterDevices = printerDevices;
            this.macAddress = printerDevices.getMacAddress();
            this.callbackListener = printerDevices.getCallbackListener();
            this.command = printerDevices.getCommand();
            this.isSafety = printerDevices.isSafety();
        }
    }

    public void addCallBackListener(CallbackListener listener) {
        this.callbackListenerList.add(listener);
    }

    public void removeCallBackListener(CallbackListener listener) {
        this.callbackListenerList.remove(listener);
    }

    @Override
    public boolean openPort() {
        LogUtils.e(TAG, "try to open connect printer");
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mAdapter == null) {
            throw new RuntimeException("The device does not support Bluetooth\uff01");
        }
        if (this.mAdapter.isDiscovering()) {
            this.mAdapter.cancelDiscovery();
        }
        if (!this.mAdapter.isEnabled()) {
            LogUtils.e(TAG, "Bluetooth is not turned on...");
            return false;
        }
        try {
            if (this.callbackListener != null) {
                UIThreadManager.onUIThread(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPort.this.callbackListener.onConnecting();
                    }
                });
            }
            if (BluetoothAdapter.checkBluetoothAddress((String)this.macAddress)) {
                this.device = this.mAdapter.getRemoteDevice(this.macAddress);
                this.mPrinterDevices.setBlueName(this.device.getName());
                this.mSocket = this.isSafety ? this.device.createRfcommSocketToServiceRecord(SERIAL_PORT_SERVICE_CLASS_UUID) : this.device.createInsecureRfcommSocketToServiceRecord(SERIAL_PORT_SERVICE_CLASS_UUID);
                this.mSocket.connect();
                this.inputStream = this.mSocket.getInputStream();
                this.outputStream = this.mSocket.getOutputStream();
                this.isConn = true;
                if (this.callbackListener != null) {
                    if (this.command == null) {
                        UIThreadManager.onUIThread(new Runnable(){

                            @Override
                            public void run() {
                                BluetoothPort.this.callbackListener.onCheckCommand();
                            }
                        });
                        this.checkPrinterCommand();
                    } else {
                        this.setSuccessListen(this.command);
                    }
                }
                this.reader = new IoReader();
                this.reader.start();
                return true;
            }
            new RuntimeException("Bluetooth address is invalid");
            this.setFailureListen();
            return false;
        }
        catch (IOException e) {
            this.setFailureListen();
            return false;
        }
    }

    private void checkPrinterCommand() throws IOException {
        int status = -1;
        status = this.getPrinterStatus(Command.ESC);
        if (status == -1) {
            status = this.getPrinterStatus(Command.CPCL);
            if (status == -1) {
                status = this.getPrinterStatus(Command.TSC);
                if (status == -1) {
                    this.setFailureListen();
                } else {
                    this.setSuccessListen(Command.TSC);
                }
            } else {
                this.setSuccessListen(Command.CPCL);
            }
        } else {
            this.setSuccessListen(Command.ESC);
        }
    }

    private void setSuccessListen(Command command) {
        this.command = command;
        this.mPrinterDevices.setCommand(command);
        if (this.callbackListener != null) {
            UIThreadManager.onUIThread(new Runnable(){

                @Override
                public void run() {
                    BluetoothPort.this.callbackListener.onSuccess(BluetoothPort.this.mPrinterDevices);
                }
            });
        }
    }

    private void setFailureListen() {
        if (this.callbackListener != null) {
            UIThreadManager.onUIThread(new Runnable(){

                @Override
                public void run() {
                    BluetoothPort.this.callbackListener.onFailure();
                }
            });
        }
    }

    @Override
    public boolean writeDataImmediately(byte[] data) throws IOException {
        if (this.mSocket != null && this.outputStream != null && data != null) {
            try {
                this.outputStream.write(data, 0, data.length);
                this.outputStream.flush();
                return true;
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Exception occur while sending data immediately: ", (Throwable)e);
                this.isConn = false;
                if (this.callbackListener != null) {
                    UIThreadManager.onUIThread(new Runnable(){

                        @Override
                        public void run() {
                            BluetoothPort.this.callbackListener.onDisconnect();
                        }
                    });
                }
                throw e;
            }
        }
        return false;
    }

    @Override
    public PrinterDevices getPrinterDevices() {
        return this.mPrinterDevices;
    }

    @Override
    public boolean writeDataImmediately(Vector<Byte> data) throws IOException {
        if (this.mSocket != null && this.outputStream != null && data != null) {
            try {
                Log.e((String)TAG, (String)("send\r\n" + data.size() + "\t" + SDKUtils.bytesToHexString(SDKUtils.convertVectorByteToBytes(data))));
                this.outputStream.write(SDKUtils.convertVectorByteToBytes(data), 0, data.size());
                this.outputStream.flush();
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Exception occur while sending data to printer: ", (Throwable)e);
                this.isConn = false;
                if (this.callbackListener != null) {
                    UIThreadManager.onUIThread(new Runnable(){

                        @Override
                        public void run() {
                            BluetoothPort.this.callbackListener.onDisconnect();
                        }
                    });
                }
                throw e;
            }
            finally {
                data.clear();
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getPrinterStatus(Command command) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[DOLOOP]], but top level block is 50[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] getKey() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.byteArrayOutputStream.size() > 0) {
                this.byteArrayOutputStream.reset();
            }
        }
        String command = "READ_INFO ID\r\n";
        this.writeDataImmediately(command.getBytes("GB18030"));
        long endTime = SystemClock.uptimeMillis() + 3000L;
        byte[] recv = null;
        int len = 0;
        if (this.reader == null) {
            do {
                if (this.inputStream.available() > 0) {
                    recv = new byte[this.inputStream.available()];
                    len = this.inputStream.read(recv);
                }
                if (len > 0) return null;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (endTime > SystemClock.uptimeMillis());
            return null;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            while (this.byteArrayOutputStream.size() == 0 && endTime > SystemClock.uptimeMillis()) {
                try {
                    this.lock.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.byteArrayOutputStream == null || this.byteArrayOutputStream.size() <= 0) return null;
            return this.byteArrayOutputStream.toByteArray();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getPower() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 22[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPrinterModel(Command command) throws IOException {
        if (command == null) {
            return "";
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.byteArrayOutputStream.size() > 0) {
                this.byteArrayOutputStream.reset();
            }
        }
        switch (command) {
            case ESC: {
                byte[] esc = new byte[]{29, 73, 67};
                this.writeDataImmediately(esc);
                break;
            }
            case TSC: {
                byte[] tsc = new byte[]{126, 33, 84, 13, 10};
                this.writeDataImmediately(tsc);
                break;
            }
            case CPCL: {
                byte[] cpcl = new byte[]{27, 118};
                this.writeDataImmediately(cpcl);
            }
        }
        long endTime = SystemClock.uptimeMillis() + 2000L;
        byte[] recv = null;
        if (this.reader == null) {
            do {
                if (this.inputStream.available() > 0) {
                    if (recv == null) {
                        recv = new byte[this.inputStream.available()];
                    }
                    this.inputStream.read(recv);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (endTime > SystemClock.uptimeMillis());
        } else {
            Object object2 = this.lock;
            synchronized (object2) {
                while (endTime > SystemClock.uptimeMillis()) {
                    try {
                        this.lock.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        if (this.byteArrayOutputStream != null && this.byteArrayOutputStream.size() > 0) {
            LogUtils.e("model length" + this.byteArrayOutputStream.size());
            return this.byteArrayOutputStream.toString();
        }
        return null;
    }

    @Override
    public void setCommand(Command command) {
        this.command = command;
    }

    @Override
    public Command getCommand() {
        return this.command;
    }

    public static Bitmap cutBitmap(Bitmap bitmap, int y, int height) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        Log.e((String)String.valueOf(w), (String)String.valueOf(h));
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)y, (int)w, (int)height, null, (boolean)false);
    }

    @Override
    @RequiresApi(api=21)
    public boolean writePDFToEsc(File file, int width) throws Exception {
        Bitmap[] bitmaps = PDFUtils.PDFToBitmap(file, width);
        if (bitmaps == null) {
            return false;
        }
        for (int i = 0; i < bitmaps.length; ++i) {
            byte[] data = PDFUtils.drawEscPDF(bitmaps[i]);
            this.writeDataImmediately(data);
            if (i != bitmaps.length - 1) continue;
            return true;
        }
        byte[] command = new byte[]{10, 29, 86, 66, 0, 27, 64};
        this.writeDataImmediately(command);
        return false;
    }

    @Override
    @RequiresApi(api=21)
    public boolean writePDFToTsc(File file, int printWidth, int gap, boolean cut, boolean dpi200, boolean compression, int cutHeight) throws Exception {
        if (file == null) {
            throw new Exception("File cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(printWidth))) {
            throw new Exception("printWidth cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(gap))) {
            throw new Exception("gap cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(cutHeight))) {
            throw new Exception("cutHeight cannot be empty");
        }
        Bitmap[] bitmaps = PDFUtils.PDFToBitmap(file, printWidth);
        if (bitmaps == null) {
            return false;
        }
        if (gap > 0 | cutHeight == 0) {
            for (int i = 0; i < bitmaps.length; ++i) {
                byte[] data;
                String size = "\r\nSIZE " + bitmaps[i].getWidth() / (dpi200 ? 8 : 12) + " mm," + bitmaps[i].getHeight() / (dpi200 ? 8 : 12) + " mm\r\n";
                this.writeDataImmediately(size.getBytes("GB18030"));
                String GAP = "GAP " + gap + " mm,0 mm\r\n";
                if (cut && i == bitmaps.length - 1) {
                    this.writeDataImmediately("SET CUTTER 1\r\n".getBytes("GB18030"));
                } else {
                    this.writeDataImmediately("SET CUTTER OFF\r\n".getBytes("GB18030"));
                }
                this.writeDataImmediately(GAP.getBytes("GB18030"));
                String cls = "CLS\r\n";
                this.writeDataImmediately(cls.getBytes("GB18030"));
                if (compression) {
                    data = PDFUtils.drawTscPDFLib(bitmaps[i]);
                    this.writeDataImmediately(data);
                } else {
                    data = PDFUtils.drawTscPDF(bitmaps[i]);
                    this.writeDataImmediately(data);
                }
                String print = "\r\nPRINT 1\r\n";
                this.writeDataImmediately(print.getBytes("GB18030"));
                if (i != bitmaps.length - 1) continue;
                return true;
            }
        } else {
            for (int i = 0; i < bitmaps.length; ++i) {
                List<Bitmap> mlist = BluetoothPort.ImageCrop(bitmaps[i], cutHeight);
                for (int j = 0; j < mlist.size(); ++j) {
                    byte[] data;
                    String size = "\r\nSIZE " + mlist.get(j).getWidth() / (dpi200 ? 8 : 12) + " mm," + mlist.get(j).getHeight() / (dpi200 ? 8 : 12) + " mm\r\n";
                    this.writeDataImmediately(size.getBytes("GB18030"));
                    String GAP = "GAP 0 mm,0 mm\r\n";
                    if (cut && j == mlist.size() - 1 && i == bitmaps.length - 1) {
                        this.writeDataImmediately("SET CUTTER 1\r\n".getBytes("GB18030"));
                    } else {
                        this.writeDataImmediately("SET CUTTER OFF\r\n".getBytes("GB18030"));
                    }
                    this.writeDataImmediately(GAP.getBytes("GB18030"));
                    String cls = "CLS\r\n";
                    this.writeDataImmediately(cls.getBytes("GB18030"));
                    if (compression) {
                        data = PDFUtils.drawTscPDFLib(mlist.get(j));
                        this.writeDataImmediately(data);
                    } else {
                        data = PDFUtils.drawTscPDF(mlist.get(j));
                        this.writeDataImmediately(data);
                    }
                    String print = "\r\nPRINT 1\r\n";
                    this.writeDataImmediately(print.getBytes("GB18030"));
                }
                if (i != bitmaps.length - 1) continue;
                mlist.clear();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean writeBitmapToTsc(Bitmap mBitmap, int printWidth, boolean cut, boolean dpi200, boolean compression, int cutHeight) throws Exception {
        if (mBitmap == null) {
            throw new Exception("Bitmap cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(printWidth))) {
            throw new Exception("printWidth cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)String.valueOf(cutHeight))) {
            throw new Exception("cutHeight cannot be empty");
        }
        if (mBitmap != null) {
            int width = (printWidth + 7) / 8 * 8;
            int height = mBitmap.getHeight() * width / mBitmap.getWidth();
            Log.d((String)"BMP", (String)("bmp.getWidth() " + mBitmap.getWidth()));
            Bitmap rszBitmap = GpUtils.resizeImage(mBitmap, width, height);
            List<Bitmap> mlist = BluetoothPort.ImageCrop(rszBitmap, cutHeight);
            for (int j = 0; j < mlist.size(); ++j) {
                String size = "\r\nSIZE " + mlist.get(j).getWidth() / (dpi200 ? 8 : 12) + " mm," + mlist.get(j).getHeight() / (dpi200 ? 8 : 12) + " mm\r\n";
                this.writeDataImmediately(size.getBytes("GB18030"));
                String gap = "GAP 0 mm,0 mm\r\n";
                this.writeDataImmediately(gap.getBytes("GB18030"));
                if (cut && j == mlist.size() - 1) {
                    this.writeDataImmediately("SET CUTTER 1\r\n".getBytes("GB18030"));
                } else {
                    this.writeDataImmediately("SET CUTTER OFF\r\n".getBytes("GB18030"));
                }
                String cls = "CLS\r\n";
                this.writeDataImmediately(cls.getBytes("GB18030"));
                byte[] data = PDFUtils.drawTscPDFLib(mlist.get(j));
                this.writeDataImmediately(data);
                String print = "\r\nPRINT 1\r\n";
                this.writeDataImmediately(print.getBytes("GB18030"));
                if (j != mlist.size() - 1) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Bitmap> ImageCrop(Bitmap bitmap, int photoheight) {
        ArrayList<Bitmap> list = new ArrayList<Bitmap>();
        int last = bitmap.getHeight() % photoheight;
        for (int i = 0; i < bitmap.getHeight() - bitmap.getHeight() % photoheight; i += photoheight) {
            list.add(BluetoothPort.cutBitmap(bitmap, i, photoheight));
        }
        if (last > 0) {
            Bitmap cp = BluetoothPort.cutBitmap(bitmap, bitmap.getHeight() - bitmap.getHeight() % photoheight, bitmap.getHeight() % photoheight);
            list.add(cp);
        }
        return list;
    }

    @Override
    public int readData(byte[] bytes) throws IOException {
        this.len = -1;
        if (this.mSocket == null || this.inputStream == null) {
            throw new IOException();
        }
        try {
            if (this.inputStream.available() > 0) {
                this.len = this.inputStream.read(bytes);
                LogUtils.e(TAG, "printer data return : \t" + SDKUtils.bytesToHexString(bytes));
            }
            return this.len;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"BlueDevice connection device is lost");
            this.isConn = false;
            throw e;
        }
    }

    @Override
    public synchronized boolean closePort() {
        try {
            this.mPrinterDevices = null;
            this.isConn = false;
            this.command = null;
            if (this.mAdapter != null) {
                this.mAdapter = null;
            }
            if (this.reader != null) {
                this.reader.cancel();
                this.reader.interrupt();
                this.reader = null;
            }
            if (this.mSocket != null) {
                this.mSocket.close();
            }
            if (this.device != null) {
                this.device = null;
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (this.byteArrayOutputStream != null) {
                this.byteArrayOutputStream.close();
            }
            this.macAddress = null;
            LogUtils.e(TAG, "close success");
            return true;
        }
        catch (IOException e) {
            LogUtils.e(TAG, "close error" + e);
            return false;
        }
    }

    class IoReader
    extends Thread {
        private boolean isRun = true;

        public void cancel() {
            this.isRun = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (this.isRun) {
                    LogUtils.e(TAG, "\u8bfb\u6570\u636e...");
                    BluetoothPort.this.len = BluetoothPort.this.inputStream.read(BluetoothPort.this.buffer);
                    LogUtils.e(TAG, "len..." + BluetoothPort.this.len);
                    if (BluetoothPort.this.len <= 0) continue;
                    Object object = BluetoothPort.this.lock;
                    synchronized (object) {
                        final byte[] receive = SDKUtils.subBytes(BluetoothPort.this.buffer, 0, BluetoothPort.this.len);
                        BluetoothPort.this.byteArrayOutputStream.write(receive);
                        BluetoothPort.this.lock.notifyAll();
                        Thread.sleep(10L);
                        UIThreadManager.onUIThread(new Runnable(){

                            @Override
                            public void run() {
                                BluetoothPort.this.callbackListener.onReceive(receive);
                            }
                        });
                    }
                }
                return;
            }
            catch (Exception e) {
                BluetoothPort.this.isConn = false;
                if (BluetoothPort.this.callbackListener == null) return;
                UIThreadManager.onUIThread(new Runnable(){

                    @Override
                    public void run() {
                        LogUtils.e(TAG, "\u65ad\u5f00\u8fde\u63a5");
                        BluetoothPort.this.callbackListener.onDisconnect();
                    }
                });
            }
        }
    }
}

